<?php $__env->startSection('content'); ?>

<div class="row">

    <div class="col-md-12" itemscope itemtype="http://schema.org/MobileApplication">
        <div class="block block-themed">

            <div class="bg-white">
                <div class="content">
                    <!-- Search -->
                    <form class="push" action="<?php echo e(route('web.app.search')); ?>">
                        <div class="input-group input-group-lg">
                            <input type="text" name="q" class="form-control form-control-alt" placeholder="Search apps">
                            <div class="input-group-append">
                                <span class="input-group-text border-0 bg-body">
                                    <i class="fa fa-fw fa-search"></i>
                                </span>
                            </div>
                        </div>
                    </form>
                    <!-- END Search -->
                </div>
            </div>

            <div class="block-content p-4">
                <h4 class="border-bottom border-gray pb-2 mb-0"> <?php echo __('dcm.search_result_title', ['attr' => $searchResults->count(), 'search' => $searchInput ?? '']); ?></h4>
            </div>

            <?php if(!$searchResults->isEmpty()): ?>
                <?php $__currentLoopData = $searchResults->groupByType(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $modelSearchResults): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="block-content p-4">
                        <strong class="mt-2 pb-2 mb-0"> <span ><?php echo e(ucwords($type)); ?></span> results.</strong>
                        <?php $__currentLoopData = $modelSearchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $searchResult): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="media text-muted pt-3">
                                <img src="<?php echo e($searchResult->searchable->app_image_url ?? asset('img/default-app.png')); ?>" class="mr-3" alt="<?php echo e(__('dcm.download_apk_title')); ?> - <?php echo e($searchResult->title); ?>" width="30px">
                                
                                <div class="media-body">
                                    <h6 class="mt-0">
                                        <a href="<?php echo e($searchResult->url); ?>" title="<?php echo e(__('dcm.download_apk_title')); ?> - <?php echo e($searchResult->title); ?>">
                                            <i class="fab fa-android"></i> <?php echo e($searchResult->title); ?>

                                        </a>
                                        <a  href="<?php echo e($searchResult->url); ?>" title="<?php echo e(__('dcm.download_apk_title')); ?> - <?php echo e($searchResult->title); ?>"> <i class="fa fa-download text-dark" style="float:right;"></i> </a>
                                    </h6>
                                    <p ><?php echo e(str_limit(e($searchResult->searchable->description), 200)); ?> </p>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="media text-muted pt-3 ">
                    <div class="media-body mb-4 text-center">
                        <?php echo e(__('dcm.no_result')); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>

    </div>

</div>




<?php $__env->stopSection(); ?>


<?php $__env->startPush('javascript'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make( "layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>